/******************** (C) COPYRIGHT 2003 STMicroelectronics ********************
* File Name          : 71x_conf.h
* Author             : MCD Application Team
* Date First Issued  : 18/07/2003
* Description        : Library configuration for the STR71x Real Time 
*                      Clock Application Example application note (AN 1780).
********************************************************************************
* History:
*  04/10/2003 : V1.0
*  30/11/2004 : V2.0
*******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
#ifndef __71x_CONF_H
#define __71x_CONF_H

/* Comment the line below to put the library in release mode */
#define DEBUG


#define inline __inline

#define USE_SERIAL_PORT
#define USE_UART0
//#define USE_UART1
//#define USE_UART2
//#define USE_UART3

#define USE_LCD


/* Comment the lines below corresponding to unwanted peripherals */
//#define _ADC12

//#define _APB
//#define _APB1
//#define _APB2

//#define _BSPI
//#define _BSPI0
//#define _BSPI1

//#define _CAN

#define _EIC

#define _EMI

//#define _FLASH

#define _GPIO
#define _GPIO0
#define _GPIO1
#define _GPIO2

//#define _I2C
//#define _I2C0
//#define _I2C1

#define _PCU

#define _RCCU

#define _RTC

//#define _TIM
//#define _TIM0
//#define _TIM1
//#define _TIM2
//#define _TIM3

#define _UART
#define _UART0
//#define _UART1
//#define _UART2
//#define _UART3

//#define _USB

//#define _WDG

//#define _XTI


//#define _IRQVectors


#ifdef USE_LCD
  #include "lcd.h"
#endif

#ifdef USE_SERIAL_PORT


#define UART0_Rx_Pin (0x0001<<8)   // TQFP 64: pin N 63 , TQFP 144 pin N 143
#define UART0_Tx_Pin (0x0001<<9)   // TQFP 64: pin N 64 , TQFP 144 pin N 144

#define UART1_Rx_Pin (0x0001<<10)  // TQFP 64: pin N 1  , TQFP 144 pin N 1
#define UART1_Tx_Pin (0x0001<<11)  // TQFP 64: pin N 2  , TQFP 144 pin N 3

#define UART2_Rx_Pin (0x0001<<13)  // TQFP 64: pin N 5  , TQFP 144 pin N 9
#define UART2_Tx_Pin (0x0001<<14)  // TQFP 64: pin N 6  , TQFP 144 pin N 10

#define UART3_Rx_Pin (0x0001<<1)   // TQFP 64: pin N 52 , TQFP 144 pin N 123
#define UART3_Tx_Pin (0x0001<<0)   // TQFP 64: pin N 53 , TQFP 144 pin N 124

   #ifdef USE_UART0
     #define  UARTX  UART0
     #define  UARTX_Rx_Pin  UART0_Rx_Pin
     #define  UARTX_Tx_Pin  UART0_Tx_Pin
     #define  UARTX_Periph  UART0_Periph
   #endif /* Use_UART0 */

   #ifdef USE_UART1
     #define  UARTX  UART1
     #define  UARTX_Rx_Pin  UART1_Rx_Pin
     #define  UARTX_Tx_Pin  UART1_Tx_Pin
     #define  UARTX_Periph  UART1_Periph
   #endif /* Use_UART1 */

   #ifdef USE_UART2
     #define  UARTX  UART2
     #define  UARTX_Rx_Pin  UART2_Rx_Pin
     #define  UARTX_Tx_Pin  UART2_Tx_Pin
     #define  UARTX_Periph  UART2_Periph
   #endif /* Use_UART2 */

   #ifdef USE_UART3
     #define  UARTX  UART3
     #define  UARTX_Rx_Pin  UART3_Rx_Pin
     #define  UARTX_Tx_Pin  UART3_Tx_Pin
     #define  UARTX_Periph  UART3_Periph
   #endif /* Use_UART3 */
#endif
#endif /* __71x_CONF_H */
/******************* (C) COPYRIGHT 2003 STMicroelectronics *****END OF FILE****/
